package gov.va.vinci.dart.db;

import java.util.List;

import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.DartRequest;
import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.Review;
import gov.va.vinci.dart.biz.ReviewTemplate;
import gov.va.vinci.dart.service.DartObjectFactory;

public class TestReviewDAO extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
	}
	
	@Test
	public void testOne() throws Exception {

		Review review = DartObjectFactory.getInstance().getReviewDAO().findById(0);
		Assert.assertNull(review);

		List<DartRequest> reqList = DartObjectFactory.getInstance().getDartRequestDAO().listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest request = reqList.get(0);
		Assert.assertNotNull(request);
		Assert.assertTrue(request.getId() > 0);

		List<ReviewTemplate> rtList = DartObjectFactory.getInstance().getReviewTemplateDAO().listAll();
		Assert.assertNotNull(rtList);
		Assert.assertTrue(rtList.size() > 0);
		
		ReviewTemplate template = rtList.get(0);
		Assert.assertNotNull(template);
		Assert.assertTrue(template.getId() > 0);
		
		Group reviewer = template.getReviewer();
		Assert.assertNotNull(reviewer);
		Assert.assertTrue(reviewer.getId() > 0);

		Review rev = Review.create(null, request, template, reviewer, "Please do this review"); // request, template, group, string
		Assert.assertNotNull(rev);
		Assert.assertTrue(rev.getId() > 0);
		
		List<Review> rList = DartObjectFactory.getInstance().getReviewDAO().listAll();
		 
		Assert.assertNotNull(rList);
		Assert.assertTrue(rList.size() > 0);
		Assert.assertTrue(rList.contains(rev));
	}

	@Test
	public void testTwo() throws Exception {

		Review review = DartObjectFactory.getInstance().getReviewDAO().findById(0);
		Assert.assertNull(review);

		List<DartRequest> reqList = DartObjectFactory.getInstance().getDartRequestDAO().listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest request = reqList.get(0);
		Assert.assertNotNull(request);
		Assert.assertTrue(request.getId() > 0);

		List<ReviewTemplate> rtList = DartObjectFactory.getInstance().getReviewTemplateDAO().listAll();
		Assert.assertNotNull(rtList);
		Assert.assertTrue(rtList.size() > 0);
		
		ReviewTemplate template = rtList.get(0);
		Assert.assertNotNull(template);
		Assert.assertTrue(template.getId() > 0);
		
		Group reviewer = template.getReviewer();
		Assert.assertNotNull(reviewer);
		Assert.assertTrue(reviewer.getId() > 0);

		Review rev = Review.create(null, request, template, reviewer, "Please do this review"); // request, template, group, string
		Assert.assertNotNull(rev);
		Assert.assertTrue(rev.getId() > 0);
		
		List<Review> rList = DartObjectFactory.getInstance().getReviewDAO().listByRequestId(request.getId());
		 
		Assert.assertNotNull(rList);
		Assert.assertTrue(rList.size() > 0);
		Assert.assertTrue(rList.contains(rev));
	}

	@Test
	public void testThree() throws Exception {

		Review review = DartObjectFactory.getInstance().getReviewDAO().findById(0);
		Assert.assertNull(review);

		List<DartRequest> reqList = DartObjectFactory.getInstance().getDartRequestDAO().listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest request = reqList.get(0);
		Assert.assertNotNull(request);
		Assert.assertTrue(request.getId() > 0);

		List<ReviewTemplate> rtList = DartObjectFactory.getInstance().getReviewTemplateDAO().listAll();
		Assert.assertNotNull(rtList);
		Assert.assertTrue(rtList.size() > 0);
		
		ReviewTemplate template = rtList.get(0);
		Assert.assertNotNull(template);
		Assert.assertTrue(template.getId() > 0);
		
		Group reviewer = template.getReviewer();
		Assert.assertNotNull(reviewer);
		Assert.assertTrue(reviewer.getId() > 0);

		Review rev = Review.create(null, request, template, reviewer, "Please do this review"); // request, template, group, string
		Assert.assertNotNull(rev);
		Assert.assertTrue(rev.getId() > 0);
		
		List<Review> rList = DartObjectFactory.getInstance().getReviewDAO().listByGroupId(reviewer.getId());
		 
		Assert.assertNotNull(rList);
		Assert.assertTrue(rList.size() > 0);
		Assert.assertTrue(rList.contains(rev));
	}

	@Test
	public void testFour() throws Exception {

		Review review = DartObjectFactory.getInstance().getReviewDAO().findById(0);
		Assert.assertNull(review);

		List<DartRequest> reqList = DartObjectFactory.getInstance().getDartRequestDAO().listAll();
		Assert.assertNotNull(reqList);
		Assert.assertTrue(reqList.size() > 0);

		DartRequest request = reqList.get(0);
		Assert.assertNotNull(request);
		Assert.assertTrue(request.getId() > 0);

		List<ReviewTemplate> rtList = DartObjectFactory.getInstance().getReviewTemplateDAO().listAll();
		Assert.assertNotNull(rtList);
		Assert.assertTrue(rtList.size() > 0);
		
		ReviewTemplate template = rtList.get(0);
		Assert.assertNotNull(template);
		Assert.assertTrue(template.getId() > 0);
		
		Group reviewer = template.getReviewer();
		Assert.assertNotNull(reviewer);
		Assert.assertTrue(reviewer.getId() > 0);

		Review rev = Review.create(null, request, template, reviewer, "Please do this review"); // request, template, group, string
		Assert.assertNotNull(rev);
		Assert.assertTrue(rev.getId() > 0);
		
		List<Review> rList = DartObjectFactory.getInstance().getReviewDAO().listAll();
		 
		Assert.assertNotNull(rList);
		Assert.assertTrue(rList.size() > 0);
		Assert.assertTrue(rList.contains(rev));
		
		DartObjectFactory.getInstance().getReviewDAO().delete(rev);

		rList = DartObjectFactory.getInstance().getReviewDAO().listAll();
		 
		Assert.assertNotNull(rList);
		Assert.assertFalse(rList.contains(rev));
	}
}
